/*Exercice 3
Pour simuler un croisement routier,  sens unique, on utilise 3 files f1, f2 et f3 reprsentant respectivement 
les voitures arrivant sur les routes R1 et R2, et les voitures partant sur la route R3. La route R2 a un STOP, 
les voitures de la file f2 ne peuvent avancer que sil ny a au-cune voiture sur la route R1, donc dans la file f1.
 
Lalgorithme de simulation utilisera une boucle sans fin.
 chaque itration, il sera fait un appel  la procdure arrive(f1, f2) qui simule larrive dune ou 
plusieurs voitures des files f1 et f2, modifiant ainsi leur tat en mmoire.
 Si l'on considre que les files sont infinies, quelle structure de donnes choisir ?
 Admettons que les files ne sont pas infinies. La taille de nos files est limite  
  une variable MAX saisie par lutilisateur et symbolisant le maximum de voitures que peut 
  accueillir une route et la procdure arrive(f1, f2) prend en compte cette nouvelle hypothse.

  Programmer une simulation.
Nous ajoutons maintenant une nouvelle hypothse  notre problme : le STOP est respect mais la 
voiture de la route R2 peut tre prioritaire par rapport  la route R1. C'est--dire que si la 
distance entre la premire voiture de la route R1 et le croisement est juge suffisante par votre 
simulateur, on prfrera dfiler f2 plutt que f1. La vitesse des voitures est juge constante.

Modifier le programme prcdent en ajoutant cette prcision.
*/

// VERSION 2 : CONTROLE DE LA DISTANCE ET NOMBRE ILLIMITE DE VOITURES

// REMARQUE :
// La version 3 avec un nombre limit de voiture et sans pile gnrique
// est beaucoup plus simple et peut-tre plus facile  comprendre pour
// commencer.

#include<stdio.h>
#include<stdlib.h>
#include<conio.h>
#include<time.h>
#include<string.h>

#define DISTANCE_MIN	50

enum { FALSE, TRUE };

typedef struct Voiture {
	int lettre;
	int distance;
	// etc.
}Voiture;


// File gnrique qui peut contenir n'importe quelle type de structure
typedef struct Elem {
	void* data;		// pointera sur des donnes, Client ou autre 
	struct Elem* suiv;
}Elem;

typedef struct Queue {
	Elem* out;		// tete, premier
	Elem* in;		// queue, dernier
}Queue;

void Menu(void);
// gestion voitures
void ArriveeVoitures(Queue** Q1, Queue** Q2);
_Bool ProcheVoiture(Voiture* v);
void AvanceVoiture(Voiture* v);
Voiture* CreateVoiture(int lettre, int distance);
void DisplayVoiture(Voiture* c);
void DisplayQueueVoiture(Queue* q, int num);
int Top(int* start, int duree);
void ClearVoiture(Voiture* c);
void ClearAllVoitures(Queue* q);
void DestroyAllQueueVoiture(Queue** q);

// gestion file
Queue* CreateQueue(void);
Elem* CreateElem(void* data);
_Bool EmptyQueue(Queue* f);
void EnqueueElem(Queue** f, Elem* e);
Elem* DequeueElem(Queue* f);


int main()
{
	int fin = 0;
	Queue* Q1 = NULL;
	Queue* Q2 = NULL;
	Queue* Q3 = NULL;

	srand((unsigned int)time(NULL));

	int start = 0;
	Menu();
	while (fin != 'q') {

		// Le dfilement contrl au clavier (plus facile  voir)
		if (_kbhit()) {
			fin = _getch();

			//avancer voiture file 1
			if(!EmptyQueue(Q1))
				AvanceVoiture(Q1->out->data);

			// arrives en R1, R2
			if (fin == 'a')
				ArriveeVoitures(&Q1, &Q2);

			// passages en R3
			else if (fin == 'z') {

				//passage de R1  R3
				if (!EmptyQueue(Q1) && ProcheVoiture(Q1->out->data)) {
					EnqueueElem(&Q3, DequeueElem(Q1));
				}
				// passage de R2  R3
				else if (!EmptyQueue(Q2)) {
					EnqueueElem(&Q3, DequeueElem(Q2));
				}
			}
			// Disparition en R3
			else if (fin == 'e') {
				if (!EmptyQueue(Q3))
					free(DequeueElem(Q3));
			}
			DisplayQueueVoiture(Q1, 1);
			DisplayQueueVoiture(Q2, 2);
			DisplayQueueVoiture(Q3, 3);
		}
	}
	DestroyAllQueueVoiture(&Q1);
	DestroyAllQueueVoiture(&Q2);
	DestroyAllQueueVoiture(&Q3);
	return 0;
}
void Menu()
{
	printf("SI CONTROLE MANUEL :\n");
	printf("a : Arrivee voitures\n");
	printf("z : Passages R1 ou R2 vers R3\n");
	printf("e : Retirer une voiture de la file R3 \n");
	printf("q : Quitter\n");
}
/*************************************************************
Gestion voitures
**************************************************************/
void ArriveeVoitures(Queue** q1, Queue** q2)
{
	static int lettre = 'A';
	if (rand() % 2) {
		EnqueueElem(q1, CreateElem(CreateVoiture(lettre++, rand() % (DISTANCE_MIN * 2))));
	}

	if (rand() % 2)
		EnqueueElem(q2, CreateElem(CreateVoiture(lettre++, 0)));

	lettre %= ('A' + 26);
}
void AvanceVoiture(Voiture* v)
{
	if(v != NULL)
		v->distance = (v->distance <= 10) ? 0 : v->distance - 10;
}
_Bool ProcheVoiture(Voiture* v)
{
	_Bool res = TRUE;
	if(v != NULL)
		res = (v->distance < DISTANCE_MIN) ? TRUE : FALSE;
	return res;
}

Voiture * CreateVoiture(int lettre, int distance)
{
	Voiture* v = (Voiture*)malloc(sizeof(Voiture));
	if (v) {
		v->lettre = lettre;
		v->distance = distance;
	}

	return v;
}
void DisplayVoiture(Voiture * v)
{
	printf("%c%d ", v->lettre, v->distance);
}
void DisplayQueueVoiture(Queue * q, int num)
{
	printf("R%d : ", num);
	if (!EmptyQueue(q)) {
		// affichage tte jusqu' queue
		Elem* e = q->out;
		if (e != NULL) {

			while (e != NULL) {
				DisplayVoiture((Voiture*)e->data);
				e = e->suiv;
			}
		}
		else
			printf("-");
	}
	else
		printf("-");
	putchar('\n');
}
int Top(int* start, int duree)
{
	int res = FALSE;
	if (clock() > * start + duree) {
		*start = clock();
		res = TRUE;
	}
	return res;
}
// les fonctions de dsallocation implique la suppression des clients
// en plus de celles des lments de la file et de la file, du coup
// elles ne sont que partiellement gnriques
void ClearVoiture(Voiture * v)
{
	if (v != NULL) {
		free(v);
	}
}
void ClearAllVoitures(Queue * q)
{
	if (q != NULL) {
		while (q->out != NULL) {
			Elem* e = q->out;
			q->out = q->out->suiv;
			ClearVoiture((Voiture*)e->data);
			free(e);
		}
		q->out = NULL;
		q->in = NULL;
	}
}
void DestroyAllQueueVoiture(Queue * *q)
{
	if (!EmptyQueue(*q)) {
		ClearAllVoitures(*q);
		free(*q);
		*q = NULL;
	}
}

/*************************************************************
Gestion File gnrique
**************************************************************/
Queue* CreateQueue()
{
	Queue* q = (Queue*)malloc(sizeof(Queue));
	if (q) {
		// premier entr, premier sorti, first in, first out (FIFO)
		q->out = NULL;  // tte, first
		q->in = NULL;	// queue, last
	}
	return q;
}
Elem* CreateElem(void* data)
{
	Elem* e = (Elem*)malloc(sizeof(Elem));
	if (e) {
		e->data = data;
		e->suiv = NULL;
	}
	return e;
}
_Bool EmptyQueue(Queue * q)
{
	return (q != NULL && (q->out != NULL)) ? FALSE : TRUE;
}
void EnqueueElem(Queue * *q, Elem * e)  // enfiler
{
	if (e != NULL) {
		//si la file n'existe pas la crer
		if (*q == NULL)
			* q = CreateQueue();
		// si elle est vide 
		if ((*q)->out == NULL)
			(*q)->out = (*q)->in = e;
		// si elle n'est pas vide ajout en fin de file
		else {
			(*q)->in->suiv = e;
			(*q)->in = e;
		}
	}
}
Elem* DequeueElem(Queue * f) // dfiler
{
	Elem* e = NULL;
	if (!EmptyQueue(f)) {
		e = f->out;
		f->out = f->out->suiv;
		e->suiv = NULL; // attention

		// attention lors de la suppression du dernier out ET in doivent tre  null
		if (f->out == NULL)
			f->in = NULL;
	}
	return e;
}